/**
 * Type definitions for Middle East Events platform
 */

export interface Event {
  id: string;
  name: string;
  date: string;
  endDate?: string;
  attendeesRange: string;
  venue: string;
  city: string;
  country: string;
  ticketAvailable: boolean;
  pricing?: string;
  description: string;
  attendeeProfiles: string;
  sponsors: string[];
  eventType: EventType;
  imageUrl?: string;
  websiteUrl?: string;
  createdAt: string;
  updatedAt: string;
}

export type EventType = 
  | 'conference'
  | 'exhibition'
  | 'summit'
  | 'festival'
  | 'trade-show'
  | 'networking'
  | 'workshop'
  | 'concert'
  | 'sports'
  | 'other';

export interface EventFilters {
  search: string;
  eventType: EventType | 'all';
  country: string;
  dateRange: 'all' | 'this-week' | 'this-month' | 'next-month';
  ticketAvailable: boolean | null;
}

export interface FindAllCandidate {
  candidate_id: string;
  name: string;
  url?: string;
  description?: string;
  match_status: 'matched' | 'unmatched' | 'generated';
  output?: Record<string, {
    value: string;
    type: string;
    is_matched?: boolean;
  }>;
  basis?: Array<{
    field: string;
    citations: Array<{
      title: string;
      url: string;
      excerpts: string[];
    }>;
    reasoning: string;
    confidence: string;
  }>;
}

export interface FindAllRunStatus {
  findall_id: string;
  status: {
    status: 'pending' | 'running' | 'completed' | 'failed';
    is_active: boolean;
    metrics: {
      generated_candidates_count: number;
      matched_candidates_count: number;
    };
  };
  generator: string;
  created_at: string;
  modified_at: string;
}

export interface FindAllResult {
  findall_id: string;
  status: {
    status: string;
    is_active: boolean;
    metrics: {
      generated_candidates_count: number;
      matched_candidates_count: number;
    };
  };
  candidates: FindAllCandidate[];
}

